/** @file   wingedai.cpp
 * @brief   Implementation of WingedAI class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:44 $
 * @author  Tomi Lamminsaari
 */


#include "wingedai.h" // class's header file
#include "www_assert.h"
#include "warglobals.h"
#include "utils.h"
using eng2d::Vec2D;

namespace WeWantWar {


const float WingedAI::REATTACK_DISTANCE = 250;
const float WingedAI::ATTACK_DISTANCE = 180;

/** Constructor
 */
WingedAI::WingedAI( GameObject* pAlien ) :
  AIController( pAlien, WarGlobals::pObjTable->pPlayer ),
  
  m_evading( false ),
  m_evadeCounter( -1 )
{
  AIController::m_attackRange = 180;
  
	WWW_ASSERT( WarGlobals::pObjTable->pPlayer != 0 );
	WWW_ASSERT( pAlien != 0 );
}



/** Destructor.
 */
WingedAI::~WingedAI()
{
	
}



/** The update-method
 */
void WingedAI::updateAI( bool seeTarget, float dist )
{

  this->reset();
  this->forward() = 1;
  
  m_evadeCounter -= 1;
  
  if ( seeTarget == true ) {
    int d = 0;
    if ( m_evading == true && m_evadeCounter > 0 ) {
      // Try to go away from the target.
      d = Utils::findTurningDir( m_pTarget->position(), m_pObject->position(),
                                 m_pObject->angle() );
      if ( dist > REATTACK_DISTANCE ) {
        m_evading = false;
      }
      
    } else {
      // Try to attack the player.
      d = Utils::findTurningDir( m_pObject->position(), m_pTarget->position(),
                                 m_pObject->angle() );
      if ( this->withinAttackRange() == true ) {
        m_evading = true;
        m_evadeCounter = 100;
        this->shoot() = 1;
        this->setCounter( 4 );
        return;
      }
    }
    this->turn() = 4 * d;
    this->setCounter( 3 );
    
  } else {
    // We don't see player. We move randomly.
    this->turn() = (rand() % 2 == 0) ? -1 : 1;
    this->setCounter( 15 + rand() % 10 );
  }
  this->avoidWalls();
}

} // end of namespace

/**
 * Version history
 * ===============
 * $Log: wingedai.cpp,v $
 * Revision 1.1.1.1  2006/01/21 23:02:44  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:15:38+02  lamminsa
 * Initial revision
 *
 */
 
